#include "prologin.hh"
#include <iostream>
#include <vector>

using namespace std;

/*
Principe:
Chaque île possède une unique caravelle qui lui est associée
Les îles neutres sont conquises une par une en s'éloignant progressivement de la base
Une seule caravelle est chargée de la conquête d'îles neutres
Les autres s'occupent du transfert d'argent, notamment depuis les volcans
*/

///
// Déclarations globales
//
vector<position> iles;
vector<position> volcans;
vector<position> mesIles;
vector<position> mesVolcans;
int nb_galions;
int nb_caravelles;
vector<int> caravelles;
position prochaineConquete;
int ileConquerante;

void deplacement(int id, position dest);

///
// Fonction appelée au début du Jeu
//
void partie_init()
{
    nb_galions = 0;
    nb_caravelles = 0;
    prochaineConquete = mes_iles()[0];
    ileConquerante = -1;
}


///
// Fonction appelée à chaque tour de Jeu
//
void jouer_tour()
{
    /*/ DEBUG
    if(mon_joueur() == 1)
    {
        if(ileConquerante != -1) cout << "Caravelle N°" << caravelles[ileConquerante] << " appartenant à l'ile N°" << ileConquerante << ", en " << info_bateau(caravelles[ileConquerante]).pos.x << " " << info_bateau(caravelles[ileConquerante]).pos.y << endl;
        cout << "Cible en " << prochaineConquete.x << " " << prochaineConquete.y << endl << endl;
    }
    /*/
    


    ///////////////////
    //    GENERAL    //
    ///////////////////

    // Préliminaires

    for(unsigned int i = 0 ; i < liste_iles().size() ; i++)
    {
        if(info_terrain(liste_iles()[i]) == TERRAIN_ILE) iles.push_back(liste_iles()[i]);
        else volcans.push_back(liste_iles()[i]);
    }
    for(unsigned int i = 0 ; i < mes_iles().size() ; i++)
    {
        if(info_terrain(mes_iles()[i]) == TERRAIN_ILE) mesIles.push_back(mes_iles()[i]);
        else mesVolcans.push_back(mes_iles()[i]);
    }
    caravelles.resize(mesIles.size(), -1); // On ajuste le tableau des caravelles au tableau des îles

    // Construction des bateaux

    for(unsigned int i = 0 ; i < mesIles.size() ; i++) // Pour chaque île
    {
        if(caravelles[i] == -1 && info_ile_or(mesIles[i]) >= CARAVELLE_COUT) // Construction de la première caravelle
        {
            construire(BATEAU_CARAVELLE, mesIles[i]);
            caravelles[i] = id_dernier_bateau_construit();
            if(ileConquerante == -1) ileConquerante = caravelles[i]; // La première île est conquérante
        }
  
        if(caravelles[i] != -1) while(construire(BATEAU_GALION, mesIles[i]) == OK); // Construction des galions
    }



    //////////////////////
    //    CARAVELLES    //
    //////////////////////


    //// CONQUÊTES

    // Choix de la conquête

    if(info_ile_joueur(prochaineConquete) != -1) // Si la conquête est finie (succès ou échec) on change
    {
        int min_dist = -1, id = -1;
        for(unsigned int i = 0 ; i < liste_iles().size() ; i++) // Pour chaque île
        {
            if(info_ile_joueur(liste_iles()[i]) != -1) continue; // Non conquise
            int tmp = distance(mesIles[0], liste_iles()[i]);
            if(min_dist == -1 || tmp < min_dist) // On recherche l'île la plus proche de la base
            {
                min_dist = tmp;
                id = i;
            }
        }
        if(id != -1) prochaineConquete = liste_iles()[id]; // Si on a trouvé une conquête
        else ileConquerante = -1;
    }

    // Choix de la caravelle conquérante

    if(ileConquerante != -1) // Si une conquête est en cours
    {
        int min_dist = -1, id = -1;
        for(unsigned int i = 0 ; i < mesIles.size() ; i++) // Pour chaque île possédée
        {
            if(caravelles[i] == -1) continue; // Si elle a construit une caravelle
            int tmp = distance(info_bateau(caravelles[i]).pos, prochaineConquete);
            if(min_dist == -1 || tmp < min_dist) // On recherche la caravelle la plus proche de la conquête
            {
                min_dist = tmp;
                id = i;
            }
        }
        ileConquerante = id;
    }

    // Deplacement vers la conquête

    if(ileConquerante != -1) // Si une conquête est en cours
        deplacement(caravelles[ileConquerante], prochaineConquete);

    // Conquête

    if(ileConquerante != -1 && // Si une conquête est en cours
       distance(info_bateau(caravelles[ileConquerante]).pos, prochaineConquete) == 0)
        coloniser(prochaineConquete);
    
    
    //// TRANSFERTS
    
    for(unsigned int i = 0 ; i < mesIles.size() ; i++) // Pour chaque île possédée
    {
        if(i == ileConquerante) continue; // Sauf l'île conquérante
        if(info_bateau(caravelles[i]).nb_or > 20)
        {
        
        }
        else
        {
        
        }
    }
    
    
    
    ///////////////////
    //    GALIONS    //
    ///////////////////

}


///
// Fonction appelée à la fin du Jeu
//
void partie_fin()
{

}

void deplacement(int id, position dest)
{
    if(distance(info_bateau(id).pos, prochaineConquete) <= CARAVELLE_DEPLACEMENT)
        deplacer(id, prochaineConquete);
    else
    {
        position bateau, cible;
        bateau.x = info_bateau(id).pos.x, bateau.y = info_bateau(id).pos.y;
        cible.x = prochaineConquete.x, cible.y = prochaineConquete.y;
        while(distance(bateau, cible) > CARAVELLE_DEPLACEMENT)
        {
            if(abs(bateau.x - cible.x) > abs(bateau.y - cible.y))
            {
                if(cible.x > bateau.x) cible.x--;
                else cible.x++;
            }
            else
            {
                if(cible.y > bateau.y) cible.y--;
                else cible.y++;
            }
        }
        deplacer(id, cible);
    }
}

